/*
 * Decompiled with CFR 0.152.
 */
package dev.toma.gunsrpg.network.packet;

import dev.toma.gunsrpg.common.tileentity.AmmoBenchTileEntity;
import dev.toma.gunsrpg.network.AbstractNetworkPacket;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.IPacket;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.fml.network.NetworkEvent;

public class C2S_AmmoBenchEventPacket
extends AbstractNetworkPacket<C2S_AmmoBenchEventPacket> {
    private final BlockPos pos;
    private final boolean recipeSelection;
    private final int direction;

    public C2S_AmmoBenchEventPacket() {
        this(null, false, 0);
    }

    private C2S_AmmoBenchEventPacket(BlockPos pos, boolean recipeSelectionMode, int direction) {
        this.pos = pos;
        this.recipeSelection = recipeSelectionMode;
        this.direction = direction;
    }

    public static C2S_AmmoBenchEventPacket craftingEvent(BlockPos pos) {
        return new C2S_AmmoBenchEventPacket(pos, false, 0);
    }

    public static C2S_AmmoBenchEventPacket previousRecipe(BlockPos pos) {
        return new C2S_AmmoBenchEventPacket(pos, true, -1);
    }

    public static C2S_AmmoBenchEventPacket nextRecipe(BlockPos pos) {
        return new C2S_AmmoBenchEventPacket(pos, true, 1);
    }

    @Override
    public void encode(PacketBuffer buffer) {
        buffer.func_179255_a(this.pos);
        buffer.writeBoolean(this.recipeSelection);
        if (this.recipeSelection) {
            buffer.writeInt(this.direction);
        }
    }

    @Override
    public C2S_AmmoBenchEventPacket decode(PacketBuffer buffer) {
        BlockPos pos = buffer.func_179259_c();
        boolean recipeSelection = buffer.readBoolean();
        int direction = recipeSelection ? buffer.readInt() : 0;
        return new C2S_AmmoBenchEventPacket(pos, recipeSelection, direction);
    }

    @Override
    protected void handlePacket(NetworkEvent.Context context) {
        ServerPlayerEntity player = context.getSender();
        ServerWorld world = player.func_71121_q();
        if (!world.func_195588_v(this.pos)) {
            return;
        }
        TileEntity tileEntity = world.func_175625_s(this.pos);
        if (!(tileEntity instanceof AmmoBenchTileEntity)) {
            return;
        }
        AmmoBenchTileEntity ammoBench = (AmmoBenchTileEntity)tileEntity;
        if (!this.recipeSelection) {
            if (ammoBench.isCrafting()) {
                return;
            }
            ammoBench.startCrafting(player);
        } else {
            if (this.direction > 0 && ammoBench.canSelectNextRecipe()) {
                ammoBench.setRecipeIndex(ammoBench.getSelectedRecipeIndex() + 1);
            }
            if (this.direction < 0 && ammoBench.canSelectPreviousRecipe()) {
                ammoBench.setRecipeIndex(ammoBench.getSelectedRecipeIndex() - 1);
            }
            player.field_71133_b.func_184103_al().func_148540_a((IPacket)ammoBench.func_189518_D_());
        }
    }
}

